<?php

namespace src\Service;

use src\Conexao\Conexao;

class tipoTrabalhoService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function listar($paginaAtual = 1, $itensPorPagina = 20, $termoPesquisa = null)
    {
        $offset = ($paginaAtual - 1) * $itensPorPagina;

        $queryTotal = "SELECT COUNT(*) as total FROM tipo_trabalho";
        $query = "SELECT * FROM tipo_trabalho";

        if (!empty($termoPesquisa)) {
            $termoPesquisa = '%' . $termoPesquisa . '%';
            $queryTotal .= " WHERE nome LIKE ?";
            $query .= " WHERE nome LIKE ?";
        }

        $queryTotal .= " ORDER BY id DESC";
        $stmtTotal = $this->conn->prepare($queryTotal);
        if (!$stmtTotal) {
            throw new \Exception("Erro ao preparar a consulta de total: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmtTotal->bind_param("s", $termoPesquisa);
        }

        $stmtTotal->execute();
        $resultTotal = $stmtTotal->get_result();
        $totalRegistro = $resultTotal->fetch_object()->total;
        $stmtTotal->close();

        $query .= " ORDER BY id DESC LIMIT ?, ?";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmt->bind_param("sii", $termoPesquisa, $offset, $itensPorPagina);
        } else {
            $stmt->bind_param("ii", $offset, $itensPorPagina);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $tipos_trabalhos = [];
        while ($row = $result->fetch_object()) {
            $tipos_trabalhos[] = $row;
        }

        $stmt->close();

        return [
            'paginaAtual' => intval($paginaAtual),
            'itensPorPagina' => intval($itensPorPagina),
            'totalRegistro' => $totalRegistro,
            'dados' => $tipos_trabalhos
        ];
    }

    public function localizar($id)
    {
        $query = "SELECT * FROM tipo_trabalho WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();

        $result = $stmt->get_result();
        $tipo_trabalho = $result->fetch_object();

        return $tipo_trabalho;
    }

    public function deletar($id)
    {
        $query = "DELETE FROM tipo_trabalho WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();
    }

    public function salvar(\src\Model\tipoTrabalhoModel $tipoTrabalho)
    {
        $query = "INSERT INTO tipo_trabalho (nome) VALUES (?)";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $nome = $tipoTrabalho->getNome();
        $stmt->bind_param("s", $nome);
        $stmt->execute();
    }

    public function atualizar(\src\Model\tipoTrabalhoModel $tipoTrabalho)
    {
        $query = "UPDATE tipo_trabalho SET nome = ? WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $nome = $tipoTrabalho->getNome();
        $id = $tipoTrabalho->getId();
        $stmt->bind_param("si", $nome, $id);
        $stmt->execute();
    }

    public function autoComplete() {
        $query = "SELECT id, nome FROM tipo_trabalho";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $tipos_trabalhos = [];
        while ($row = $result->fetch_object()) {
            $tipos_trabalhos[] = $row;
        }

        $stmt->close();

        return $tipos_trabalhos;
    }
}
