<?php

namespace src\Service;

use src\Conexao\Conexao;

class propostaService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function listar($paginaAtual = 1, $itensPorPagina = 20, $termoPesquisa = null)
    {
        $offset = ($paginaAtual - 1) * $itensPorPagina;

        $queryTotal = "SELECT COUNT(*) as total FROM proposta p LEFT JOIN cliente c on c.id = p.id_cliente";
        $query = "SELECT p.*, tt.nome as tipo_trabalho, c.nome FROM proposta p LEFT JOIN cliente c on c.id = p.id_cliente LEFT JOIN tipo_trabalho tt on p.id_tipo_trabalho = tt.id";

        if (!empty($termoPesquisa)) {
            $termoPesquisa = '%' . $termoPesquisa . '%';
            $queryTotal .= " WHERE c.nome LIKE ?";
            $query .= " WHERE c.nome LIKE ?";
        }

        $stmtTotal = $this->conn->prepare($queryTotal);
        if (!$stmtTotal) {
            throw new \Exception("Erro ao preparar a consulta de total: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmtTotal->bind_param("s", $termoPesquisa);
        }

        $stmtTotal->execute();
        $resultTotal = $stmtTotal->get_result();
        $totalRegistro = $resultTotal->fetch_object()->total;
        $stmtTotal->close();

        $query .= " ORDER BY p.id DESC LIMIT ?, ?";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmt->bind_param("sii", $termoPesquisa, $offset, $itensPorPagina);
        } else {
            $stmt->bind_param("ii", $offset, $itensPorPagina);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $propostas = [];
        while ($row = $result->fetch_object()) {
            $propostas[] = $row;
        }

        $stmt->close();

        return [
            'paginaAtual' => intval($paginaAtual),
            'itensPorPagina' => intval($itensPorPagina),
            'totalRegistro' => $totalRegistro,
            'dados' => $propostas
        ];
    }

    public function localizar($id)
    {
        $query = "SELECT * FROM proposta WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();

        $result = $stmt->get_result();
        $proposta = $result->fetch_object();

        return $proposta;
    }

    public function deletar($id)
    {
        $query = "DELETE FROM proposta WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();
    }

    public function salvar(\src\Model\propostaModel $propostaModel)
    {
        $query = "INSERT INTO proposta (id_cliente, valor, descricao, data_criado, data_aceito, data_agendamento, id_tipo_trabalho, nome_proposta, status_pagamento) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $idCliente = $propostaModel->getId_cliente();
        $valor = $propostaModel->getValor();
        $descricao = $propostaModel->getDescricao();
        $dataCriado = $propostaModel->getData_criado();
        $dataAceito = $propostaModel->getData_aceito();
        $dataAgendamento = $propostaModel->getData_agendamento();
        $idTipoTrabalho = $propostaModel->getId_tipo_trabalho();
        $nomeProposta = $propostaModel->getNome_proposta();
        $statusPagamento = $propostaModel->getStatus_pagamento();

        $stmt->bind_param("issssssss", $idCliente, $valor, $descricao, $dataCriado, $dataAceito, $dataAgendamento, $idTipoTrabalho, $nomeProposta, $statusPagamento);
        $stmt->execute();
    }

    public function atualizar(\src\Model\propostaModel $propostaModel)
    {

        $query = "UPDATE proposta SET id_cliente = ?, valor = ?, descricao = ?, data_criado = ?, data_aceito = ?, data_agendamento = ?, id_tipo_trabalho = ?, nome_proposta = ?, status_pagamento = ? WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $id = $propostaModel->getId();
        $idCliente = $propostaModel->getId_cliente();
        $valor = $propostaModel->getValor();
        $descricao = $propostaModel->getDescricao();
        $dataCriado = $propostaModel->getData_criado();
        $dataAceito = $propostaModel->getData_aceito();
        $dataAgendamento = $propostaModel->getData_agendamento();
        $idTipoTrabalho = $propostaModel->getId_tipo_trabalho();
        $nomeProposta = $propostaModel->getNome_proposta();
        $statusPagamento = $propostaModel->getStatus_pagamento();

        $stmt->bind_param("issssssssi", $idCliente, $valor, $descricao, $dataCriado, $dataAceito, $dataAgendamento, $idTipoTrabalho, $nomeProposta, $statusPagamento, $id);
        $stmt->execute();
    }
}
