<?php

namespace src\Service;

class logMensagemService
{
    public function listarPaginado($paginaAtual = 1, $itensPorPagina = 20) {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $offset = ($paginaAtual - 1) * $itensPorPagina;

        $queryTotal = "SELECT COUNT(*) as total FROM log_mensagem";
        $stmtTotal = $conn->prepare($queryTotal);
        if (!$stmtTotal) {
            echo "Erro ao preparar a consulta de total: " . $conn->error;
            return null;
        }
        $stmtTotal->execute();
        $resultTotal = $stmtTotal->get_result();
        $totalRegistro = $resultTotal->fetch_object()->total;
        $stmtTotal->close();

        $query = "SELECT * FROM log_mensagem ORDER BY id DESC LIMIT ?, ?";
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }
        $stmt->bind_param("ii", $offset, $itensPorPagina);
        $stmt->execute();
        $result = $stmt->get_result();

        $logMensagem = [];
        while ($row = $result->fetch_object()) {
            $logMensagem[] = $row;
        }

        $stmt->close();
        $conn->close();

        return [
            'paginaAtual' => intval($paginaAtual),
            'itensPorPagina' => intval($itensPorPagina),
            'totalRegistro' => $totalRegistro,
            'dados' => $logMensagem
        ];
    }

    public function salvar(\src\Model\logMensagemModel $logMensagem) {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "INSERT INTO log_mensagem (tipo_envio, mensagem) VALUES (?, ?)";
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $tipo_envio = $logMensagem->getTipo_envio();
        $mensagem = $logMensagem->getMensagem();

        $stmt->bind_param("ss", $tipo_envio, $mensagem);
        $stmt->execute();
        $stmt->close();
        $conn->close();
    }

    public function localizar($id) {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "SELECT * FROM log_mensagem WHERE id = ?";
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $logMensagem = $result->fetch_object();

        $stmt->close();
        $conn->close();

        return $logMensagem;
    }
}
