<?php

namespace src\Service;

use src\Conexao\Conexao;

class financeiroService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function listar($paginaAtual = 1, $itensPorPagina = 20, $data_inicial = null, $data_final = null, $situacao = null, $id_cliente = null)
    {
        $offset = ($paginaAtual - 1) * $itensPorPagina;
    
        $queryTotal = "SELECT COUNT(*) as total FROM financeiro f LEFT JOIN cliente c on c.id = f.id_cliente";
        $query = "SELECT f.*, c.nome FROM financeiro f LEFT JOIN cliente c on c.id = f.id_cliente";
    
        $conditions = [];
        $params = [];
        $types = '';
    
        // Adiciona filtros de data
        if (!empty($data_inicial) && !empty($data_final)) {
            $conditions[] = "f.data BETWEEN ? AND ?";
            $params[] = $data_inicial;
            $params[] = $data_final;
            $types .= 'ss';
        } elseif (!empty($data_inicial) || !empty($data_final)) {
            throw new \Exception("Ambas as datas, data_inicial e data_final, devem ser fornecidas.");
        }
    
        // Adiciona filtro de situação
        if (!empty($situacao)) {
            $conditions[] = "f.situacao = ?";
            $params[] = $situacao;
            $types .= 's';
        }
    
        // Adiciona filtro de cliente
        if (!empty($id_cliente)) {
            $conditions[] = "c.id = ?";
            $params[] = $id_cliente;
            $types .= 'i';
        }
    
        // Aplica as condições às consultas
        if (!empty($conditions)) {
            $whereClause = " WHERE " . implode(' AND ', $conditions);
            $queryTotal .= $whereClause;
            $query .= $whereClause;
        }
    
        // Prepara e executa a consulta de contagem total
        $stmtTotal = $this->conn->prepare($queryTotal);
        if (!$stmtTotal) {
            throw new \Exception("Erro ao preparar a consulta de total: " . $this->conn->error);
        }
    
        if (!empty($params)) {
            $stmtTotal->bind_param($types, ...$params);
        }
    
        $stmtTotal->execute();
        $resultTotal = $stmtTotal->get_result();
        $totalRegistro = $resultTotal->fetch_object()->total;
        $stmtTotal->close();
    
        // Adiciona ordenação e paginação à consulta principal
        $query .= " ORDER BY f.data DESC LIMIT ?, ?";
        $params[] = $offset;
        $params[] = $itensPorPagina;
        $types .= 'ii';
    
        // Prepara e executa a consulta principal
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }
    
        $stmt->bind_param($types, ...$params);
    
        $stmt->execute();
        $result = $stmt->get_result();
    
        $financeiro = [];
        while ($row = $result->fetch_object()) {
            $financeiro[] = $row;
        }
    
        $stmt->close();
    
        return [
            'paginaAtual' => intval($paginaAtual),
            'itensPorPagina' => intval($itensPorPagina),
            'totalRegistro' => $totalRegistro,
            'dados' => $financeiro
        ];
    }

    public function localizar($id)
    {
        $query = "SELECT * FROM financeiro WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();

        $result = $stmt->get_result();
        $financeiro = $result->fetch_object();

        return $financeiro;
    }

    public function salvar(\src\Model\financeiroModel $financeiro) {
        $query = "INSERT INTO financeiro (valor, data, situacao, descricao, id_cliente, forma_pagamento) VALUES (?, ?, ?, ?, ?, ?)";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $valor = $financeiro->getValor();
        $data = $financeiro->getData();
        $situacao = $financeiro->getSituacao();
        $descricao = $financeiro->getDescricao();
        $idCliente = $financeiro->getId_cliente();
        $forma_pagamento = $financeiro->getForma_pagamento();

        $stmt->bind_param(
            'ssssis',
            $valor,
            $data,
            $situacao,
            $descricao,
            $idCliente,
            $forma_pagamento
        );

        $stmt->execute();

        $stmt->close();
    }

    public function atualizar(\src\Model\financeiroModel $financeiro)
    {
        $query = "UPDATE financeiro SET valor = ?, data = ?, situacao = ?, descricao = ?, id_cliente = ?, forma_pagamento = ? WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $valor = $financeiro->getValor();
        $data = $financeiro->getData();
        $situacao = $financeiro->getSituacao();
        $descricao = $financeiro->getDescricao();
        $idCliente = $financeiro->getId_cliente();
        $forma_pagamento = $financeiro->getForma_pagamento();
        $id = $financeiro->getId();

        $stmt->bind_param(
            'ssssisi',
            $valor,
            $data,
            $situacao,
            $descricao,
            $idCliente,
            $forma_pagamento,
            $id
        );

        $stmt->execute();

        $stmt->close();
    }

    public function deletar($id)
    {
        $query = "DELETE FROM financeiro WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param('i', $id);

        $stmt->execute();

        $stmt->close();
    }

}
