<?php

namespace src\Service;

use src\Utils\responseHelpers;
use Exception;

class enviarMensagemService
{

    public function enviarMensagem($configuracoes, $numero, $mensagem)
    {
        try {

            $messageData = [
                "messageData" => [
                    "numero" => $numero,
                    "text" => 'string'
                ]
            ];

            // Verifique se todas as variáveis necessárias estão definidas
            if (isset($configuracoes->urlConexaoWhatsApp, $configuracoes->idInstancia, $configuracoes->licenca)) {
                $urlDois = $configuracoes->urlConexaoWhatsApp . '/' . $configuracoes->idInstancia . '/rest/envio/' . $configuracoes->licenca . '/texto';

                $url = 'https://api.zeus.falewhats.com.br/b41eb38870db213c4f94ab0481f1de9b/rest/envio/Q6TPGUA-NDMULOA-S7SOWGQ-J2LFUJA/texto';

                echo $url . '<br>';
                echo $urlDois . '<br>';


                // Verifique se a URL está correta
                if (filter_var($url, FILTER_VALIDATE_URL)) {
                    $ch = curl_init($url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        'Content-Type: application/json'
                    ]);

                    $jsonData = json_encode($messageData);

                    echo '<pre> ' . $jsonData . '</pre>';

                    if (json_last_error() !== JSON_ERROR_NONE) {
                        throw new Exception('Erro ao codificar dados JSON: ' . json_last_error_msg());
                    }

                    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

                    // $response = curl_exec($ch);

                    if (curl_errno($ch)) {
                        throw new Exception('Erro no cURL: ' . curl_error($ch));
                    } else {
                        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                        if ($httpCode == 200) {
                            echo 'Mensagem enviada com sucesso!';
                        } else {
                            throw new Exception('Falha ao enviar mensagem. Código HTTP: ' . $httpCode . ' Resposta: ' . $response);
                        }
                    }

                    curl_close($ch);
                } else {
                    throw new Exception('Erro: URL malformada.');
                }
            } else {
                throw new Exception('Erro: Configurações de URL não definidas corretamente.');
            }
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
