<?php

namespace src\Service;

use src\Conexao\Conexao;

class cronService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function verificarEnsaioAgendadosHoje($dataAtual) {
        $query = "SELECT p.data_criado, p.data_aceito, p.data_agendamento, c.nome, c.sobrenome, c.telefone, tt.nome as tipo_trabalho FROM proposta p LEFT JOIN cliente c on c.id = p.id_cliente LEFT JOIN tipo_trabalho tt on tt.id = p.id_tipo_trabalho WHERE data_agendamento = ?;";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("s", $dataAtual);
       
        $stmt->execute();
        $result = $stmt->get_result();

        $agendamentos = [];
        while ($row = $result->fetch_object()) {
            $agendamentos[] = $row;
        }

        return $agendamentos;
    }

    // public function verificarEnsaioAgendadoHoje($dataAtual)
    // {
    //     $conexao = new \src\Conexao\Conexao();
    //     $conn = $conexao->getConexao();

    //     $query = "SELECT p.data_criado, p.data_aceito, p.data_agendamento, c.nome, c.sobrenome, c.telefone, tt.nome as tipo_trabalho FROM proposta p LEFT JOIN cliente c on c.id = p.id_cliente LEFT JOIN tipo_trabalho tt on tt.id = p.id_tipo_trabalho WHERE data_agendamento = ?;";

    //     $stmt = $conn->prepare($query);
    //     if (!$stmt) {
    //         echo "Erro ao preparar a consulta: " . $conn->error;
    //         return null;
    //     }

    //     $stmt->bind_param("s", $dataAtual);

    //     $stmt->execute();

    //     $result = $stmt->get_result();

    //     $ensaiosHoje = [];
    //     while ($row = $result->fetch_object()) {
    //         $ensaiosHoje[] = $row;
    //     }

    //     return $ensaiosHoje;
    // }
}
