<?php

namespace src\Service;

use src\Conexao\Conexao;

class clienteService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function autoComplete()
    {
        $query = "SELECT id, nome FROM cliente";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }
        $stmt->execute();
        $result = $stmt->get_result();

        $clientes = [];
        while ($row = $result->fetch_object()) {
            $clientes[] = $row;
        }

        return $clientes;
    }

    public function listar($paginaAtual = 1, $itensPorPagina = 20, $termoPesquisa = null)
    {
        $offset = ($paginaAtual - 1) * $itensPorPagina;

        $queryTotal = "SELECT COUNT(*) as total FROM cliente";
        $query = "SELECT * FROM cliente";

        if (!empty($termoPesquisa)) {
            $termoPesquisa = '%' . $termoPesquisa . '%';
            $queryTotal .= " WHERE nome LIKE ?";
            $query .= " WHERE nome LIKE ?";
        }

        $queryTotal .= " ORDER BY id DESC";
        $stmtTotal = $this->conn->prepare($queryTotal);
        if (!$stmtTotal) {
            throw new \Exception("Erro ao preparar a consulta de total: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmtTotal->bind_param("s", $termoPesquisa);
        }

        $stmtTotal->execute();
        $resultTotal = $stmtTotal->get_result();
        $totalRegistro = $resultTotal->fetch_object()->total;
        $stmtTotal->close();

        $query .= " ORDER BY id DESC LIMIT ?, ?";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        if (!empty($termoPesquisa)) {
            $stmt->bind_param("sii", $termoPesquisa, $offset, $itensPorPagina);
        } else {
            $stmt->bind_param("ii", $offset, $itensPorPagina);
        }

        $stmt->execute();
        $result = $stmt->get_result();

        $clientes = [];
        while ($row = $result->fetch_object()) {
            $clientes[] = $row;
        }

        $stmt->close();

        return [
            'paginaAtual' => intval($paginaAtual),
            'itensPorPagina' => intval($itensPorPagina),
            'totalRegistro' => $totalRegistro,
            'dados' => $clientes
        ];
    }

    public function salvar(\src\Model\clienteModel $clienteModel)
    {
        $query = "INSERT INTO cliente (nome, sobrenome, telefone, email, endereco, cidade, cep, data_importante, data_cadastro, descricao, bairro, onde_veio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $nome = $clienteModel->getNome();
        $sobrenome = $clienteModel->getSobrenome();
        $telefone = $clienteModel->getTelefone();
        $email = $clienteModel->getEmail();
        $endereco = $clienteModel->getEndereco();
        $cidade = $clienteModel->getCidade();
        $cep = $clienteModel->getCep();
        $dataImportante = $clienteModel->getData_importante();
        $dataCadastro = $clienteModel->getData_cadastro();
        $descricao = $clienteModel->getDescricao();
        $bairro = $clienteModel->getBairro();
        $ondeVeio = $clienteModel->getOnde_veio();

        $stmt->bind_param(
            'ssssssssssss',
            $nome,
            $sobrenome,
            $telefone,
            $email,
            $endereco,
            $cidade,
            $cep,
            $dataImportante,
            $dataCadastro,
            $descricao,
            $bairro,
            $ondeVeio
        );

        $stmt->execute();
    }

    public function atualizar(\src\Model\clienteModel $clienteModel)
    {
        $query = "UPDATE cliente SET nome = ?, sobrenome = ?, telefone = ?, email = ?, endereco = ?, cidade = ?, cep = ?, data_importante = ?, data_cadastro = ?, descricao = ?, bairro = ?, onde_veio = ? WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $id = $clienteModel->getId();
        $nome = $clienteModel->getNome();
        $sobrenome = $clienteModel->getSobrenome();
        $telefone = $clienteModel->getTelefone();
        $email = $clienteModel->getEmail();
        $endereco = $clienteModel->getEndereco();
        $cidade = $clienteModel->getCidade();
        $cep = $clienteModel->getCep();
        $dataImportante = $clienteModel->getData_importante();
        $dataCadastro = $clienteModel->getData_cadastro();
        $descricao = $clienteModel->getDescricao();
        $bairro = $clienteModel->getBairro();
        $ondeVeio = $clienteModel->getOnde_veio();

        $stmt->bind_param(
            'ssssssssssssi',
            $nome,
            $sobrenome,
            $telefone,
            $email,
            $endereco,
            $cidade,
            $cep,
            $dataImportante,
            $dataCadastro,
            $descricao,
            $bairro,
            $ondeVeio,
            $id
        );

        $stmt->execute();
        $stmt->close();
    }

    public function localizar($id)
    {
        $query = "SELECT * FROM cliente WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            throw new \Exception("Cliente não encontrado");
        }

        $cliente = $result->fetch_object();
        $stmt->close();

        return $cliente;
    }

    public function deletar($id)
    {
        $query = "DELETE FROM cliente WHERE id = ?";
        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();

        if ($stmt->affected_rows === 0) {
            throw new \Exception("Cliente não encontrado ou já deletado");
        }

        $stmt->close();
    }
}
