<?php

namespace src\Service;

use src\Conexao\Conexao;

class calendarioService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function localizar($id)
    {
        $query = "SELECT * FROM calendario WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();

        $result = $stmt->get_result();
        $evento = $result->fetch_object();

        return $evento;
    }

    public function deletar($id)
    {
        $query = "DELETE FROM calendario WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param("i", $id);
        $stmt->execute();
    }

    public function listar($mes, $ano)
    {
        $query = "SELECT * FROM calendario WHERE MONTH(data) = ? AND YEAR(data) = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param('ii', $mes, $ano);
        $stmt->execute();

        $result = $stmt->get_result();

        $eventos = [];
        while ($row = $result->fetch_object()) {
            $eventos[] = $row;
        }

        $stmt->close();

        return $eventos;
    }

    public function salvar(\src\Model\calendarioModel $calendarioModel)
    {
        $query = "INSERT INTO calendario (data, nome_cliente, contato, proposta, local, tempo_trabalho, estilo_trabalho, participantes, looks) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $data = $calendarioModel->getData();
        $nome_cliente = $calendarioModel->getNome_cliente();
        $contato = $calendarioModel->getContato();
        $proposta = $calendarioModel->getProposta();
        $local = $calendarioModel->getLocal();
        $tempo_trabalho = $calendarioModel->getTempo_trabalho();
        $estilo_trabalho = $calendarioModel->getEstilo_trabalho();
        $participantes = $calendarioModel->getParticipantes();
        $looks = $calendarioModel->getLooks();

        $stmt->bind_param('sssssssss', $data, $nome_cliente, $contato, $proposta, $local, $tempo_trabalho, $estilo_trabalho, $participantes, $looks);

        $stmt->execute();

        $stmt->close();
    }

    public function atualizar(\src\Model\calendarioModel $calendarioModel)
    {
        $query = "UPDATE calendario SET data = ?, nome_cliente = ?, contato = ?, proposta = ?, local = ?, tempo_trabalho = ?, estilo_trabalho = ?, participantes = ?, looks = ? WHERE id = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $data = $calendarioModel->getData();
        $nome_cliente = $calendarioModel->getNome_cliente();
        $contato = $calendarioModel->getContato();
        $proposta = $calendarioModel->getProposta();
        $local = $calendarioModel->getLocal();
        $tempo_trabalho = $calendarioModel->getTempo_trabalho();
        $estilo_trabalho = $calendarioModel->getEstilo_trabalho();
        $participantes = $calendarioModel->getParticipantes();
        $looks = $calendarioModel->getLooks();
        $id = $calendarioModel->getId();

        $stmt->bind_param('sssssssssi', $data, $nome_cliente, $contato, $proposta, $local, $tempo_trabalho, $estilo_trabalho, $participantes, $looks, $id);

        $stmt->execute();

        $stmt->close();
    }

    public function listarPorData($data)
    {
        $query = "SELECT * FROM calendario WHERE data = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $stmt->bind_param('s', $data);
        $stmt->execute();

        $result = $stmt->get_result();

        $eventos = [];
        while ($row = $result->fetch_object()) {
            $eventos[] = $row;
        }

        $stmt->close();

        return $eventos;
    }
}
