<?php

namespace src\Service;

use src\Conexao\Conexao;

class autenticacaoService
{

    private $conn;

    public function __construct()
    {
        $conexao = new Conexao();
        $this->conn = $conexao->getConexao();
    }

    public function autenticacao(\src\Model\autenticacaoModel $autenticacaoModel)
    {
        $query = "SELECT * FROM usuario WHERE email = ? AND senha = ?";

        $stmt = $this->conn->prepare($query);
        if (!$stmt) {
            throw new \Exception("Erro ao preparar a consulta: " . $this->conn->error);
        }

        $email = $autenticacaoModel->getEmail();
        $senha = $autenticacaoModel->getSenha();

        $stmt->bind_param('ss', $email, $senha);
        $stmt->execute();
        $result = $stmt->get_result();

        return $result->fetch_object();
    }
}
