<?php

namespace src\Migrations;

class _033_modificarEnumSituacaoFinanceiro
{
    public function up()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        // Atualize os valores existentes para corresponder aos novos valores do ENUM
        $updateQuery = "UPDATE financeiro SET situacao = 'Entrada' WHERE situacao = 'entrada'";
        $stmt = $conn->prepare($updateQuery);
        if (!$stmt) {
            echo "Erro ao preparar a consulta de atualização: " . $conn->error;
            return null;
        }
        $stmt->execute();

        $updateQuery = "UPDATE financeiro SET situacao = 'Saída' WHERE situacao = 'saida'";
        $stmt = $conn->prepare($updateQuery);
        if (!$stmt) {
            echo "Erro ao preparar a consulta de atualização: " . $conn->error;
            return null;
        }
        $stmt->execute();

        // Modifique a coluna para usar os novos valores do ENUM
        $alterQuery = "ALTER TABLE financeiro MODIFY COLUMN situacao ENUM('Entrada', 'Saída') NOT NULL DEFAULT 'Entrada'";
        $stmt = $conn->prepare($alterQuery);
        if (!$stmt) {
            echo "Erro ao preparar a consulta de alteração: " . $conn->error;
            return null;
        }
        $stmt->execute();
    }

    public function down() {}
}
