<?php

namespace src\Migrations;

class _028_criarTabelaPermissoes
{
    public function up()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "CREATE TABLE permissoes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            id_usuario INT NOT NULL,
            id_pagina INT NOT NULL,
            permissao BOOLEAN DEFAULT FALSE,
            data_criado DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            data_atualizado DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (id_usuario) REFERENCES usuario(id),
            FOREIGN KEY (id_pagina) REFERENCES paginas(id),
            UNIQUE (id_usuario, id_pagina)
        )";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }

    public function down()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "DROP TABLE permissoes";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }
}