<?php

namespace src\Migrations;

class _026_tabelaLogMensagem
{
    public function up()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "CREATE TABLE log_mensagem (
            id INT AUTO_INCREMENT PRIMARY KEY,
            tipo_envio enum('Cliente', 'Pamela') NOT NULL DEFAULT 'Cliente',
            mensagem TEXT NOT NULL,
            data_envio DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP
        )";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }

    public function down()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "DROP TABLE log_mensagem";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }
}