<?php

namespace src\Migrations;

class _017_criarTabelaLog
{
    public function up()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "CREATE TABLE log (
            id INT AUTO_INCREMENT PRIMARY KEY,
            rota VARCHAR(100) NOT NULL,
            metodo VARCHAR(100) NOT NULL,
            erro TEXT NOT NULL,
            data_hora TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }

    public function down()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "DROP TABLE log";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }
}