<?php

namespace src\Migrations;

class _007_criarTabelaProposta
{
    public function up()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "CREATE TABLE proposta (
            id INT AUTO_INCREMENT PRIMARY KEY,
            id_cliente INT NOT NULL,
            valor double NOT NULL,
            descricao TEXT NOT NULL,
            data_criado DATE NOT NULL,
            data_aceito DATE,
            data_agendamento DATE
        )";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }

    public function down()
    {
        $conexao = new \src\Conexao\Conexao();
        $conn = $conexao->getConexao();

        $query = "DROP TABLE proposta";
    
        $stmt = $conn->prepare($query);
        if (!$stmt) {
            echo "Erro ao preparar a consulta: " . $conn->error;
            return null;
        }

        $stmt->execute();
    }
}