<?php

namespace src\Controller;

use src\Service\usuarioService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\usuarioModel;
use Exception;

class usuarioController
{

    private $usuarioService;

    public function __construct(usuarioService $usuarioService)
    {
        $this->usuarioService = $usuarioService;
        token::verifyToken();
    }

    public function listar()
    {
        try {
            $termoPesquisa = $_GET['termoPesquisa'] ?? null;
            $usuarios = $this->usuarioService->listar($_GET['paginaAtual'] ?? 1, $_GET['itensPorPagina'] ?? 20, $termoPesquisa);
            responseHelpers::sendSuccessResponse($usuarios);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $usuario = $this->usuarioService->localizar($id);
            responseHelpers::sendSuccessResponse($usuario);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['nome', 'email', 'senha']);
            $data = array_map('htmlspecialchars', $data);

            $usuarioModel = new usuarioModel();
            $usuarioModel->setNome($data['nome']);
            $usuarioModel->setEmail($data['email']);
            $usuarioModel->setSenha($data['senha']);

            $this->usuarioService->salvar($usuarioModel);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'nome', 'email', 'senha']);
            $data = array_map('htmlspecialchars', $data);

            $usuarioModel = new usuarioModel();
            $usuarioModel->setId($data['id']);
            $usuarioModel->setNome($data['nome']);
            $usuarioModel->setEmail($data['email']);
            $usuarioModel->setSenha($data['senha']);

            $this->usuarioService->atualizar($usuarioModel);
            responseHelpers::sendSuccessResponse('Usuário atualizado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $this->usuarioService->deletar($id);
            responseHelpers::sendSuccessResponse('Usuário deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
