<?php

namespace src\Controller;

use src\Service\tipoTrabalhoService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\tipoTrabalhoModel;
use Exception;

class tipoTrabalhoController
{

    private $tipoTrabalhoService;

    public function __construct(tipoTrabalhoService $tipoTrabalhoService)
    {
        $this->tipoTrabalhoService = $tipoTrabalhoService;
        token::verifyToken();
    }

    public function listar()
    {
        try {
            $termoPesquisa = $_GET['termoPesquisa'] ?? null;
            $tiposTrabalhos = $this->tipoTrabalhoService->listar($_GET['paginaAtual'] ?? 1, $_GET['itensPorPagina'] ?? 20, $termoPesquisa);
            responseHelpers::sendSuccessResponse($tiposTrabalhos);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $usuario = $this->tipoTrabalhoService->localizar($id);
            responseHelpers::sendSuccessResponse($usuario);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $this->tipoTrabalhoService->deletar($id);
            responseHelpers::sendSuccessResponse('Usuário deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['nome']);
            $data = array_map('htmlspecialchars', $data);

            $tipoTrabalho = new tipoTrabalhoModel();
            $tipoTrabalho->setNome($data['nome']);

            $this->tipoTrabalhoService->salvar($tipoTrabalho);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'nome']);
            $data = array_map('htmlspecialchars', $data);

            $tipoTrabalho = new tipoTrabalhoModel();
            $tipoTrabalho->setId($data['id']);
            $tipoTrabalho->setNome($data['nome']);

            $this->tipoTrabalhoService->atualizar($tipoTrabalho);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function autocomplete() {
        try {
            $tiposTrabalhos = $this->tipoTrabalhoService->autocomplete();
            responseHelpers::sendSuccessResponse($tiposTrabalhos);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
