<?php

namespace src\Controller;

use src\Service\relatorioService;
use src\Utils\responseHelpers;
use src\Utils\token;
use Exception;

class relatorioController
{

    private $relatorioService;

    public function __construct(relatorioService $relatorioService)
    {
        $this->relatorioService = $relatorioService;
        token::verifyToken();
    }

    public function totais() {
        try {
            $ano = $_GET['ano'] ?? date('Y');
            $totais = $this->relatorioService->totais($ano);
            responseHelpers::sendSuccessResponse($totais);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function financeiro() {
        try {
            $data_inicial = $_GET['data_inicial'];
            $data_final = $_GET['data_final'];

            if (empty($data_inicial) || empty($data_final)) {
                throw new Exception('Data de início e data de fim são obrigatórios');
            }

            $financeiroGrafico = $this->relatorioService->financeiroGrafico($data_inicial, $data_final);
            $financeiro = $this->relatorioService->financeiro($data_inicial, $data_final);

            $result = [
                'grafico' => $financeiroGrafico,
                'financeiro' => $financeiro
            ];

            responseHelpers::sendSuccessResponse($result);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}