<?php 

namespace src\Controller;

use src\Service\propostaService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\propostaModel;
use Exception;

class propostaController {

    private $propostaService;

    public function __construct(propostaService $propostaService)
    {
        $this->propostaService = $propostaService;
        token::verifyToken();
    }

    public function listar()
    {
        try {
            $termoPesquisa = $_GET['termoPesquisa'] ?? null;
            $usuarios = $this->propostaService->listar($_GET['paginaAtual'] ?? 1, $_GET['itensPorPagina'] ?? 20, $termoPesquisa);
            responseHelpers::sendSuccessResponse($usuarios);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $usuario = $this->propostaService->localizar($id);
            responseHelpers::sendSuccessResponse($usuario);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id_cliente', 'valor', 'descricao', 'data_aceito', 'data_agendamento', 'id_tipo_trabalho', 'nome_proposta', 'status_pagamento']);
            $data = array_map('htmlspecialchars', $data);

            $propostaModel = new propostaModel();
            $propostaModel->setId_cliente($data['id_cliente']);
            $propostaModel->setValor($data['valor']);
            $propostaModel->setDescricao($data['descricao']);
            $propostaModel->setData_criado(date('Y-m-d'));
            $propostaModel->setData_aceito($data['data_aceito']);
            $propostaModel->setData_agendamento($data['data_agendamento']);
            $propostaModel->setId_tipo_trabalho($data['id_tipo_trabalho']);
            $propostaModel->setNome_proposta($data['nome_proposta']);
            $propostaModel->setStatus_pagamento($data['status_pagamento']);

            $this->propostaService->salvar($propostaModel);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'id_cliente', 'valor', 'descricao', 'data_aceito', 'data_agendamento', 'id_tipo_trabalho', 'nome_proposta', 'status_pagamento']);
            $data = array_map('htmlspecialchars', $data);

            $propostaModel = new propostaModel();
            $propostaModel->setId($data['id']);
            $propostaModel->setId_cliente($data['id_cliente']);
            $propostaModel->setValor($data['valor']);
            $propostaModel->setDescricao($data['descricao']);
            $propostaModel->setData_criado(date('Y-m-d'));
            $propostaModel->setData_aceito($data['data_aceito']);
            $propostaModel->setData_agendamento($data['data_agendamento']);
            $propostaModel->setId_tipo_trabalho($data['id_tipo_trabalho']);
            $propostaModel->setNome_proposta($data['nome_proposta']);
            $propostaModel->setStatus_pagamento($data['status_pagamento']);

            $this->propostaService->atualizar($propostaModel);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $this->propostaService->deletar($id);
            responseHelpers::sendSuccessResponse('Usuário deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }


}