<?php

namespace src\Controller;

use src\Service\financeiroService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\financeiroModel;
use Exception;

class financeiroController
{

    private $financeiroService;

    public function __construct(financeiroService $financeiroService)
    {
        $this->financeiroService = $financeiroService;
        token::verifyToken();
    }

    public function listar()
    {
        try {
            $financeiro = $this->financeiroService->listar($_GET['paginaAtual'] ?? 1, $_GET['itensPorPagina'] ?? 20, $_GET['data_inicial'] ?? null, $_GET['data_final'] ?? null, $_GET['situacao'] ?? null, $_GET['id_cliente'] ?? null);
            responseHelpers::sendSuccessResponse($financeiro);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $financeiro = $this->financeiroService->localizar($id);
            responseHelpers::sendSuccessResponse($financeiro);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $financeiro = $this->financeiroService->deletar($id);
            responseHelpers::sendSuccessResponse('Registro deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id_cliente', 'data', 'valor', 'situacao', 'forma_pagamento']);
            $data = array_map('htmlspecialchars', $data);

            $financeiro = new financeiroModel();
            $financeiro->setId_cliente($data['id_cliente']);
            $financeiro->setData($data['data']);
            $financeiro->setValor($data['valor']);
            $financeiro->setSituacao($data['situacao']);
            $financeiro->setDescricao($data['descricao'] ?? null);
            $financeiro->setForma_pagamento($data['forma_pagamento']);

            $this->financeiroService->salvar($financeiro);
            responseHelpers::sendSuccessResponse('Registro salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'id_cliente', 'data', 'valor', 'situacao', 'forma_pagamento']);
            $data = array_map('htmlspecialchars', $data);

            $financeiro = new financeiroModel();
            $financeiro->setId($data['id']);
            $financeiro->setId_cliente($data['id_cliente']);
            $financeiro->setData($data['data']);
            $financeiro->setValor($data['valor']);
            $financeiro->setSituacao($data['situacao']);
            $financeiro->setDescricao($data['descricao'] ?? null);
            $financeiro->setForma_pagamento($data['forma_pagamento']);

            $this->financeiroService->atualizar($financeiro);
            responseHelpers::sendSuccessResponse('Registro atualizado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
