<?php

namespace src\Controller;

use src\Service\enviarMensagemService;
use src\Utils\responseHelpers;
use Exception;

class enviarMensagemController
{
    private $enviarMensagemService;

    public function __construct(enviarMensagemService $enviarMensagemService)
    {
        $this->enviarMensagemService = $enviarMensagemService;
    }

    public function enviarMensagem($configuracoes, $numero, $mensagem)
    {
        try {
            $this->enviarMensagemService->enviarMensagem($configuracoes, $numero, $mensagem);
            responseHelpers::sendSuccessResponse('Mensagem enviada com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
