<?php

namespace src\Controller;

use src\Service\clienteService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\clienteModel;
use Exception;

class clienteController
{

    private $clienteService;

    public function __construct(clienteService $clienteService)
    {
        $this->clienteService = $clienteService;
        token::verifyToken();
    }

    public function autoComplete()
    {
        try {
            $clientes = $this->clienteService->autoComplete();
            responseHelpers::sendSuccessResponse($clientes);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function listar()
    {
        try {
            $termoPesquisa = $_GET['termoPesquisa'] ?? null;
            $tiposTrabalhos = $this->clienteService->listar($_GET['paginaAtual'] ?? 1, $_GET['itensPorPagina'] ?? 20, $termoPesquisa);
            responseHelpers::sendSuccessResponse($tiposTrabalhos);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['nome', 'sobrenome', 'telefone', 'email', 'endereco', 'cidade', 'cep', 'data_cadastro', 'bairro', 'onde_veio']);
            $data = array_map('htmlspecialchars', $data);

            $cliente = new clienteModel();
            $cliente->setNome($data['nome']);
            $cliente->setSobrenome($data['sobrenome']);
            $cliente->setTelefone($data['telefone']);
            $cliente->setEmail($data['email']);
            $cliente->setEndereco($data['endereco']);
            $cliente->setCidade($data['cidade']);
            $cliente->setCep($data['cep']);
            $cliente->setData_importante($data['data_importante'] ?? null);
            $cliente->setData_cadastro($data['data_cadastro']);
            $cliente->setDescricao($data['descricao'] ?? null);
            $cliente->setBairro($data['bairro']);
            $cliente->setOnde_veio($data['onde_veio']);

            $this->clienteService->salvar($cliente);
            responseHelpers::sendSuccessResponse('Cliente salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'nome', 'sobrenome', 'telefone', 'email', 'endereco', 'cidade', 'cep', 'data_cadastro', 'bairro', 'onde_veio']);
            $data = array_map('htmlspecialchars', $data);

            $cliente = new clienteModel();
            $cliente->setId($data['id']);
            $cliente->setNome($data['nome']);
            $cliente->setSobrenome($data['sobrenome']);
            $cliente->setTelefone($data['telefone']);
            $cliente->setEmail($data['email']);
            $cliente->setEndereco($data['endereco']);
            $cliente->setCidade($data['cidade']);
            $cliente->setCep($data['cep']);
            $cliente->setData_importante($data['data_importante'] ?? null);
            $cliente->setData_cadastro($data['data_cadastro']);
            $cliente->setDescricao($data['descricao'] ?? null);
            $cliente->setBairro($data['bairro']);
            $cliente->setOnde_veio($data['onde_veio']);

            $this->clienteService->atualizar($cliente);
            responseHelpers::sendSuccessResponse('Cliente atualizado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $this->clienteService->deletar($id);
            responseHelpers::sendSuccessResponse('Cliente deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $cliente = $this->clienteService->localizar($id);
            responseHelpers::sendSuccessResponse($cliente);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
