<?php

namespace src\Controller;

use src\Service\calendarioService;
use src\Utils\responseHelpers;
use src\Utils\validator;
use src\Utils\token;
use src\Model\calendarioModel;
use Exception;

class calendarioController
{

    private $calendarioService;

    public function __construct(calendarioService $calendarioService)
    {
        $this->calendarioService = $calendarioService;
        token::verifyToken();
    }

    public function listar()
    {
        try {

            $mes = $_GET['mes'] ?? null;
            $ano = $_GET['ano'] ?? null;

            if (!$mes || !$ano) {
                throw new Exception('Mês e ano são obrigatórios');
            }

            $usuarios = $this->calendarioService->listar($mes, $ano);
            responseHelpers::sendSuccessResponse($usuarios);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function localizar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $usuario = $this->calendarioService->localizar($id);
            responseHelpers::sendSuccessResponse($usuario);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function deletar()
    {
        try {
            $id = $_GET['id'] ?? null;
            if (!$id) {
                throw new Exception('ID é obrigatório');
            }

            $this->calendarioService->deletar($id);
            responseHelpers::sendSuccessResponse('Usuário deletado com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function salvar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['data', 'nome_cliente', 'contato', 'proposta', 'local', 'tempo_trabalho', 'estilo_trabalho', 'participantes', 'looks']);
            $data = array_map('htmlspecialchars', $data);

            $calendarioModel = new \src\Model\calendarioModel();
            $calendarioModel->setData($data['data']);
            $calendarioModel->setNome_cliente($data['nome_cliente']);
            $calendarioModel->setContato($data['contato']);
            $calendarioModel->setProposta($data['proposta']);
            $calendarioModel->setLocal($data['local']);
            $calendarioModel->setTempo_trabalho($data['tempo_trabalho']);
            $calendarioModel->setEstilo_trabalho($data['estilo_trabalho']);
            $calendarioModel->setParticipantes($data['participantes']);
            $calendarioModel->setLooks($data['looks']);

            $this->calendarioService->salvar($calendarioModel);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function atualizar()
    {
        try {
            $data = json_decode(file_get_contents('php://input'), true);
            validator::validateRequiredFields($data, ['id', 'data', 'nome_cliente', 'contato', 'proposta', 'local', 'tempo_trabalho', 'estilo_trabalho', 'participantes', 'looks']);
            $data = array_map('htmlspecialchars', $data);

            $calendarioModel = new \src\Model\calendarioModel();
            $calendarioModel->setId($data['id']);
            $calendarioModel->setData($data['data']);
            $calendarioModel->setNome_cliente($data['nome_cliente']);
            $calendarioModel->setContato($data['contato']);
            $calendarioModel->setProposta($data['proposta']);
            $calendarioModel->setLocal($data['local']);
            $calendarioModel->setTempo_trabalho($data['tempo_trabalho']);
            $calendarioModel->setEstilo_trabalho($data['estilo_trabalho']);
            $calendarioModel->setParticipantes($data['participantes']);
            $calendarioModel->setLooks($data['looks']);

            $this->calendarioService->atualizar($calendarioModel);
            responseHelpers::sendSuccessResponse('Usuário salvo com sucesso');
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }

    public function listarPorData()
    {
        try {
            $data = $_GET['data'] ?? null;

            if (!$data) {
                throw new Exception('Data é obrigatória');
            }

            $usuarios = $this->calendarioService->listarPorData($data);
            responseHelpers::sendSuccessResponse($usuarios);
        } catch (Exception $e) {
            responseHelpers::sendErrorResponse($e->getMessage(), 500);
        }
    }
}
