<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\usuarioController;
use src\Service\usuarioService;
use src\Utils\responseHelpers;

$usuarioService = new usuarioService();
$usuarioController = new usuarioController($usuarioService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $usuarioController->localizar();
            } else {
                $usuarioController->listar();
            }
            break;

        case 'POST':
            $usuarioController->salvar();
            break;

        case 'PUT':
            $usuarioController->atualizar();
            break;

        case 'DELETE':
            $usuarioController->deletar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
