<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\tipoTrabalhoController;
use src\Service\tipoTrabalhoService;
use src\Utils\responseHelpers;

$tipoTrabalhoService = new tipoTrabalhoService();
$tipoTrabalhoController = new tipoTrabalhoController($tipoTrabalhoService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $tipoTrabalhoController->localizar();
            } else {
                $tipoTrabalhoController->listar();
            }
            break;

        case 'POST':
            $tipoTrabalhoController->salvar();
            break;

        case 'PUT':
            $tipoTrabalhoController->atualizar();
            break;

        case 'DELETE':
            $tipoTrabalhoController->deletar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
