<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\relatorioController;
use src\Service\relatorioService;
use src\Utils\responseHelpers;

$relatorioService = new relatorioService();
$relatorioController = new relatorioController($relatorioService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            $relatorioController->totais();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
