<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';
require_once '../../cors/verifica-token.php';

switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        ondeVeioRelatorio();
        break;
    default:
        echo json_encode(['error' => 'Método não suportado']);
        http_response_code(405);
        break;
}

function ondeVeioRelatorio() {
    try {
        $dataInicio = $_GET['dataInicio'];
        $dataFim = $_GET['dataFim'];

        if (empty($dataInicio) || empty($dataFim)) {
            throw new Exception('Data de início e data de fim são obrigatórios');
        }

        $relatorioController = new \src\Controller\relatorioController();
        $result = $relatorioController->ondeVeio($dataInicio, $dataFim);

        echo json_encode($result);
        http_response_code(200);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}