<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\propostaController;
use src\Service\propostaService;
use src\Utils\responseHelpers;

$propostaService = new propostaService();
$propostaController = new propostaController($propostaService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $propostaController->localizar();
            } else {
                $propostaController->listar();
            }
            break;

        case 'POST':
            $propostaController->salvar();
            break;

        case 'PUT':
            $propostaController->atualizar();
            break;

        case 'DELETE':
            $propostaController->deletar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
