<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\permissaoController;
use src\Service\permissaoService;
use src\Utils\responseHelpers;

$permissaoService = new permissaoService();
$permissaoController = new permissaoController($permissaoService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
                $permissaoController->listar();
            break;

        case 'POST':
            $permissaoController->salvar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
