<?php
require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

switch ($_SERVER['REQUEST_METHOD']) {
    case 'POST':
        login();
        break;
    
    default:
        # code...
        break;
}

function login() {
    try {

        $data = json_decode(file_get_contents('php://input'), true);

        $email = $data['email'] ?? '';
        $senha = $data['senha'] ?? '';

        if (empty($email) || empty($senha)) {
            throw new Exception('Email e senha são obrigatórios');
        }

        $usuarioController = new \src\Controller\usuarioController();
        $usuario = $usuarioController->login($email, md5(md5($senha)));

        if($usuario) {

            $permissoesController = new \src\Controller\permissaoController();
            $permissoes = $permissoesController->listar($usuario->id);

            $token = [
                'permissoes' => $permissoes,
                'data' => date('Y-m-d H:i:s', strtotime('+5 hours')),
                'email' => $usuario->email,
                'nome' => $usuario->nome,
                'id' => $usuario->id,
            ];

            $token = base64_encode(json_encode($token));

            echo json_encode($token);
            http_response_code(200);
        } else {
            echo json_encode(['message' => 'Dados incorretos']);
            http_response_code(403);
        }

    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}