<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

switch ($_SERVER['REQUEST_METHOD']) {
    case 'POST':
        salvarLog();
        break;

    case 'GET':
        if (isset($_GET['id'])) {
            localizarLog();
        } else {
            listarLog();
        }
        break;

    default:
        echo json_encode(['error' => 'Método não suportado.']);
        http_response_code(405);
        break;
}

function salvarLog()
{
    try {
        $data = json_decode(file_get_contents('php://input'), true);

        $log = new \src\Model\logModel();
        $log->setRota($data['rota'] ?? '');
        $log->setMetodo($data['metodo'] ?? '');
        $log->setErro($data['erro'] ?? '');

        if (empty($log->getRota()) || empty($log->getMetodo()) || empty($log->getErro())) {
            throw new Exception('Todos os campos são obrigatórios');
        }

        $logController = new \src\Controller\logController();
        $logController->salvar($log);

        http_response_code(200);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}

function listarLog()
{
    try {

        if (!isset($_GET['paginaAtual']) || !isset($_GET['itensPorPagina'])) {
            throw new Exception('Parâmetros obrigatórios não informados');
        }

        $logController = new \src\Controller\logController();
        $logs = $logController->listarPaginado($_GET['paginaAtual'], $_GET['itensPorPagina']);

        echo json_encode($logs);
        http_response_code(200);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}

function localizarLog()
{
    try {
        $id = $_GET['id'] ?? '';

        if (empty($id)) {
            throw new Exception('ID é obrigatório');
        }

        $logController = new \src\Controller\logController();
        $log = $logController->localizar($id);

        echo json_encode($log);
        http_response_code(200);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}
