<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\financeiroController;
use src\Service\financeiroService;
use src\Utils\responseHelpers;

$financeiroService = new financeiroService();
$financeiroController = new financeiroController($financeiroService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $financeiroController->localizar();
            } else {
                $financeiroController->listar();
            }
            break;

        case 'POST':
            $financeiroController->salvar();
            break;

        case 'PUT':
            $financeiroController->atualizar();
            break;

        case 'DELETE':
            $financeiroController->deletar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
