<?php

// date_default_timezone_set('America/Sao_Paulo');

// require_once '../../vendor/autoload.php';
// require_once '../../cors/index.php';

// verificarEnsaioAgendadoHoje();

// function localizarConfiguracoesWhatsApp()
// {
//     try {
//         $geralController = new \src\Controller\geralController();
//         $configuracoes = $geralController->localizar(1);

//         if ($configuracoes) {
//             return $configuracoes;
//         } else {
//             throw new Exception('Configurações do WhatsApp não encontradas.');
//         }
//     } catch (Exception $e) {
//         echo json_encode(['error' => $e->getMessage()]);
//         http_response_code(500);
//     }
// }

// function verificarEnsaioAgendadoHoje()
// {
//     try {
//         $dataAtual = date('Y-m-d');
//         $cronController = new \src\Controller\cronController();
//         $ensaiosHoje = $cronController->verificarEnsaioAgendadoHoje($dataAtual);

//         if (count($ensaiosHoje) > 0) {
//             foreach ($ensaiosHoje as $ensaio) {
//                 enviarMensagemPamela($ensaio);
//             }
//         }

//     } catch (Exception $e) {
//         echo json_encode(['error' => $e->getMessage()]);
//         http_response_code(500);
//     }
// }

// function enviarMensagemPamela($ensaio)
// {
//     function formatarData($data)
//     {
//         $date = DateTime::createFromFormat('Y-m-d', $data);
//         return $date->format('d/m/Y');
//     }

//     function formatarTelefone($telefone)
//     {
//         $telefone = preg_replace('/[^0-9]/', '', $telefone);
//         return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $telefone);
//     }

//     $mensagem = "Olá Pamela, tudo bem? 😊\n\n";
//     $mensagem .= "Espero que você esteja tendo um dia maravilhoso! Verificamos no sistema e hoje você tem um ensaio agendado. Aqui estão as informações:\n\n";
//     $mensagem .= "📅 Data do Ensaio: " . formatarData($ensaio->data_agendamento) . "\n";
//     $mensagem .= "👤 Nome do Cliente: " . $ensaio->nome . " " . $ensaio->sobrenome . "\n";
//     $mensagem .= "📞 Telefone do Cliente: " . formatarTelefone($ensaio->telefone) . "\n";
//     $mensagem .= "📷 Tipo de Trabalho: " . $ensaio->tipo_trabalho . "\n";
//     $mensagem .= "📅 Data de Criação da Proposta: " . formatarData($ensaio->data_criado) . "\n";
//     $mensagem .= "📅 Data Aceito pelo Cliente: " . formatarData($ensaio->data_aceito) . "\n\n";
//     $mensagem .= "Por favor, acesse o sistema para mais detalhes e prepare-se para mais um ensaio incrível!\n\n";
//     $mensagem .= "Tenha um ótimo dia e bons trabalhos! 🌟\n\n";
//     $mensagem .= "_Mensagem automática, não responda._";

//     // $configuracoes = localizarConfiguracoesWhatsApp();

//     $messageData = [
//         "messageData" => [
//             "numero" => '44988012275',
//             "text" => $mensagem
//         ]
//     ];

//     echo $mensagem;

//     $url = $configuracoes->urlConexaoWhatsApp . '/' . $configuracoes->idInstancia . '/rest/envio/' . $configuracoes->licenca . '/texto';

//     $ch = curl_init($url);
//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//     curl_setopt($ch, CURLOPT_POST, true);
//     curl_setopt($ch, CURLOPT_HTTPHEADER, [
//         'Content-Type: application/json'
//     ]);
//     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messageData));

//     $response = curl_exec($ch);

//     if (curl_errno($ch)) {
//         echo 'Erro no cURL: ' . curl_error($ch);
//     } else {
//         $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
//         if ($httpCode == 200) {
//             echo 'Mensagem enviada com sucesso!';
//         } else {
//             echo 'Falha ao enviar mensagem. Código HTTP: ' . $httpCode;
//             echo 'Resposta: ' . $response;
//         }
//     }

//     curl_close($ch);

//     salvarLogMensagem($mensagem);
// }

// function salvarLogMensagem($mensagem) {
//     try {
//         $logMensagem = new \src\Model\logMensagemModel();
//         $logMensagem->setTipo_envio('Pamela');
//         $logMensagem->setMensagem($mensagem);

//         $logMensagemController = new \src\Controller\logMensagemController();
//         $logMensagemController->salvar($logMensagem);
//     } catch (Exception $e) {
//         echo json_encode(['error' => $e->getMessage()]);
//         http_response_code(500);
//     }
// }

date_default_timezone_set('America/Sao_Paulo');

require_once '../../vendor/autoload.php';
// require_once '../../cors/index.php';

use src\Controller\geralController;
use src\Service\geralService;

use src\Controller\cronController;
use src\Service\cronService;

use src\Controller\enviarMensagemController;
use src\Service\enviarMensagemService;

use src\Utils\responseHelpers;

verificarAgendamentosHoje();

function verificarConfiguracoesGerais()
{
    try {
        $geralService = new geralService();
        $geralController = new geralController($geralService);

        return $geralController->localizar();
    } catch (Exception $e) {
        ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
    }
}

function verificarAgendamentosHoje()
{
    try {
        $cronService = new cronService();
        $cronController = new cronController($cronService);

        $agendamentos = $cronController->verificarEnsaioAgendadosHoje(date('Y-m-d'));


        if (!empty($agendamentos)) {
            foreach ($agendamentos as $ensaio) {
                enviarMensagem($ensaio);
            }
        } else {
            echo "Nenhum agendamento encontrado para hoje.";
        }
    } catch (Exception $e) {
        ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
    }
}

function enviarMensagem($ensaio)
{
    try {

        $enviarMensagemService = new enviarMensagemService();
        $enviarMensagemController = new enviarMensagemController($enviarMensagemService);

        $mensagem = "Olá Pamela, tudo bem? 😊\n\n";
        $mensagem .= "Espero que você esteja tendo um dia maravilhoso! Verificamos no sistema e hoje você tem um ensaio agendado. Aqui estão as informações:\n\n";
        $mensagem .= "📅 Data do Ensaio: " . formatarData($ensaio->data_agendamento) . "\n";
        $mensagem .= "👤 Nome do Cliente: " . $ensaio->nome . " " . $ensaio->sobrenome . "\n";
        $mensagem .= "📞 Telefone do Cliente: " . formatarTelefone($ensaio->telefone) . "\n";
        $mensagem .= "📷 Tipo de Trabalho: " . $ensaio->tipo_trabalho . "\n";
        $mensagem .= "📅 Data de Criação da Proposta: " . formatarData($ensaio->data_criado) . "\n";
        $mensagem .= "📅 Data Aceito pelo Cliente: " . formatarData($ensaio->data_aceito) . "\n\n";
        $mensagem .= "Por favor, acesse o sistema para mais detalhes e prepare-se para mais um ensaio incrível!\n\n";
        $mensagem .= "Tenha um ótimo dia e bons trabalhos! 🌟\n\n";
        $mensagem .= "_Mensagem automática, não responda._";

        $configuracoes = verificarConfiguracoesGerais();

        $enviarMensagemController->enviarMensagem($configuracoes, '44988012275', $mensagem);
    } catch (Exception $e) {
        ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
    }
}

function formatarData($data)
{
    $date = DateTime::createFromFormat('Y-m-d', $data);
    return $date->format('d/m/Y');
}

function formatarTelefone($telefone)
{
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $telefone);
}


// Simulação do retorno JSON
// Decodifica para array associativo
