<?php

date_default_timezone_set('America/Sao_Paulo');

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

verificarEnsaioAgendadoHoje();

function localizarConfiguracoesWhatsApp()
{
    try {
        $geralController = new \src\Controller\geralController();
        $configuracoes = $geralController->localizar(1);

        if ($configuracoes) {
            return $configuracoes;
        } else {
            throw new Exception('Configurações do WhatsApp não encontradas.');
        }
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}

function verificarEnsaioAgendadoHoje()
{
    try {
        $dataAtual = date('Y-m-d');
        $cronController = new \src\Controller\cronController();
        $ensaiosHoje = $cronController->verificarEnsaioAgendadoHoje($dataAtual);

        if (count($ensaiosHoje) > 0) {
            foreach ($ensaiosHoje as $ensaio) {
                enviarMensagemPamela($ensaio);
            }
        }

    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}

function enviarMensagemPamela($ensaio)
{
    function formatarData($data)
    {
        $date = DateTime::createFromFormat('Y-m-d', $data);
        return $date->format('d/m/Y');
    }

    function formatarTelefone($telefone)
    {
        $telefone = preg_replace('/[^0-9]/', '', $telefone);
        return preg_replace('/(\d{2})(\d{5})(\d{4})/', '($1) $2-$3', $telefone);
    }

    $mensagem = "Olá " . $ensaio->nome . ", tudo bem? 😊\n\n";
    $mensagem .= "Espero que você esteja tendo um dia incrível! Só passando para lembrar que seu ensaio está agendado para hoje. Confira os detalhes abaixo:\n\n";
    $mensagem .= "📅 Data do Ensaio: " . formatarData($ensaio->data_agendamento) . "\n";
    $mensagem .= "📷 Tipo de Trabalho: " . $ensaio->tipo_trabalho . "\n\n";
    $mensagem .= "_Esta é uma mensagem automática. Caso tenha alguma dúvida, por favor, nos envie uma mensagem._";    

    $configuracoes = localizarConfiguracoesWhatsApp();

    $messageData = [
        "messageData" => [
            "numero" => $ensaio->telefone,
            "text" => $mensagem
        ]
    ];

    $url = $configuracoes->urlConexaoWhatsApp . '/' . $configuracoes->idInstancia . '/rest/envio/' . $configuracoes->licenca . '/texto';

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messageData));

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Erro no cURL: ' . curl_error($ch);
    } else {
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($httpCode == 200) {
            echo 'Mensagem enviada com sucesso!';
        } else {
            echo 'Falha ao enviar mensagem. Código HTTP: ' . $httpCode;
            echo 'Resposta: ' . $response;
        }
    }

    curl_close($ch);

    salvarLogMensagem($mensagem);
}

function salvarLogMensagem($mensagem) {
    try {
        $logMensagem = new \src\Model\logMensagemModel();
        $logMensagem->setTipo_envio('Cliente');
        $logMensagem->setMensagem($mensagem);

        $logMensagemController = new \src\Controller\logMensagemController();
        $logMensagemController->salvar($logMensagem);
    } catch (Exception $e) {
        echo json_encode(['error' => $e->getMessage()]);
        http_response_code(500);
    }
}