<?php 

testCurl();

function testCurl()
{
    $url = 'https://api.zeus.falewhats.com.br/b41eb38870db213c4f94ab0481f1de9b/rest/envio/Q6TPGUA-NDMULOA-S7SOWGQ-J2LFUJA/texto';
    $data = [
        "messageData" => [
            "numero" => '44988012275',
            "text" => 'string'
        ]
    ];

    $jsonData = json_encode($data);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Erro ao codificar dados JSON: ' . json_last_error_msg());
    }

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        throw new Exception('Erro no cURL: ' . curl_error($ch));
    } else {
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($httpCode == 201) { // 201 Created
            echo 'Requisição bem-sucedida! Resposta: ' . $response;
        } else {
            throw new Exception('Falha na requisição. Código HTTP: ' . $httpCode . ' Resposta: ' . $response);
        }
    }

    curl_close($ch);
}

try {
    testCurl();
} catch (Exception $e) {
    echo 'Erro: ' . $e->getMessage();
}