<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\clienteController;
use src\Service\clienteService;
use src\Utils\responseHelpers;

$clienteService = new clienteService();
$clienteController = new clienteController($clienteService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            $clienteController->autoComplete();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
