<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\calendarioController;
use src\Service\calendarioService;
use src\Utils\responseHelpers;

$calendarioService = new calendarioService();
$calendarioController = new calendarioController($calendarioService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'GET':
            if (isset($_GET['id'])) {
                $calendarioController->localizar();
            } else if(isset($_GET['data'])) {
                $calendarioController->listarPorData();
            }else {
                $calendarioController->listar();
            }
            break;

        case 'POST':
            $calendarioController->salvar();
            break;

        case 'PUT':
            $calendarioController->atualizar();
            break;

        case 'DELETE':
            $calendarioController->deletar();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
