<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';
require_once '../../cors/verifica-token.php';

switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        autoCompleteCliente();
        break;

    default:
        echo json_encode(['error' => 'Método não suportado.']);
        http_response_code(405);
        break;
}

function autoCompleteCliente()
{
    try {
        $clienteController = new \src\Controller\clienteController();
        $clientes = $clienteController->autoComplete();

        echo json_encode($clientes);
        http_response_code(200);
    } catch (\Throwable $th) {
        echo json_encode(['error' => $th->getMessage()]);
        http_response_code(400);
    }
}
