<?php

require_once '../../vendor/autoload.php';
require_once '../../cors/index.php';

use src\Controller\autenticacaoController;
use src\Service\autenticacaoService;
use src\Service\permissaoService;
use src\Utils\responseHelpers;

$autenticacaoService = new autenticacaoService();
$permissaoService = new permissaoService();
$autenticacaoController = new autenticacaoController($autenticacaoService, $permissaoService);

try {
    switch ($_SERVER['REQUEST_METHOD']) {
        case 'POST':
            $autenticacaoController->autenticacao();
            break;

        case 'OPTIONS':
            http_response_code(200);
            break;

        default:
            ResponseHelpers::sendErrorResponse('Método não suportado.', 405);
            break;
    }
} catch (Exception $e) {
    ResponseHelpers::sendErrorResponse($e->getMessage(), 500);
}
